# FDAC Open API

This API acts as a proxy between the marketplace and the APM and Catalogue, enabling the marketplace to have access to the authorized assets and training resources for the logged in user

* A JWT token is generated when a user logs in on the marketplace.
* This token is included on the Authorization header during a request made when opening a marketplace page.
* FDAC Open API will use this token to communicate with APM to obtain the elements the user is authorized to see.
* The API will communicate with the catalogue API to generate a unique temporary iframe URL, containing access to the  authorized data elements.
* The iframe URL will be used by the marketplace, since a temporary token is being used the master catalogue token is never exposed on the client side.

## Description of the API

The swagger describing the API is available on the file `swagger.json` or using the endpoint `/api-docs`

## Run as production

```
npm run start
```

## Run as development

```
npm run dev
```

## Environment variables

* **PORT**: Port where the rest API is exposed
* **IOT_CATALOGUE_URL**: Endpoint in where IoT Catalogue is running
* **IOT_CATALOGUE_TOKEN**: IoT Catalogue token
* **APM_URL**: APM API base url
* **CORS_ORIGINS**: Used to add extra origin, localhost and the default fame fdac host are already defined